/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.client.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.voxelutopia.ultramarine.client.integration.jei.UltramarinePlugin;
import com.voxelutopia.ultramarine.data.recipe.CompositeSmeltingRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CompositeSmeltingRecipeCategory
implements IRecipeCategory<CompositeSmeltingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("ultramarine", "composite_smelting");
    public static final RecipeType<CompositeSmeltingRecipe> COMPOSITE_SMELTING_RECIPE_TYPE = new RecipeType(UID, CompositeSmeltingRecipe.class);
    public static final ResourceLocation TEXTURE_GUI = new ResourceLocation("ultramarine", "textures/gui/brick_kiln.png");
    private final IDrawable background;
    private final int regularCookTime;
    private final IDrawable icon;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;

    public CompositeSmeltingRecipeCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE_GUI, 45, 16, 92, 54);
        this.regularCookTime = 200;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.BRICK_KILN.get()));
        this.localizedName = Component.m_237115_((String)"gui.jei.category.composite_smelting");
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(UltramarinePlugin.JEI_GUI_VANILLA, 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
        this.staticFlame = guiHelper.createDrawable(UltramarinePlugin.JEI_GUI_VANILLA, 82, 114, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
    }

    protected IDrawableAnimated getArrow(CompositeSmeltingRecipe recipe) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected void drawExperience(CompositeSmeltingRecipe recipe, GuiGraphics poseStack, int y) {
        float experience = recipe.getExp();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            poseStack.m_280430_(fontRenderer, (Component)experienceString, this.background.getWidth() - stringWidth, y, -8355712);
        }
    }

    protected void drawCookTime(CompositeSmeltingRecipe recipe, GuiGraphics poseStack, int y) {
        int cookTime = recipe.getCookingTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            poseStack.m_280430_(fontRenderer, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712);
        }
    }

    public RecipeType<CompositeSmeltingRecipe> getRecipeType() {
        return COMPOSITE_SMELTING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CompositeSmeltingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(recipe.getPrimaryIngredient());
        builder.addSlot(RecipeIngredientRole.INPUT, 21, 1).addIngredients(recipe.getSecondaryIngredient());
        if (Minecraft.m_91087_().f_91073_ != null) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 71, 19).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
        }
    }

    public void draw(CompositeSmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedFlame.draw(guiGraphics, 11, 20);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(guiGraphics, 34, 18);
        this.drawExperience(recipe, guiGraphics, 0);
        this.drawCookTime(recipe, guiGraphics, 45);
    }
}

